/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
import { ReportingChannel, ErrorInformation } from "report-errors/advanced";
import { WerConsent } from "wer-api-windows";
export { WerConsent };
/**
 * Constructor options
 *
 * @export
 * @interface WerReporterOptions
 */
export interface WerReporterOptions {
    /**
     * consent passed to the watson APIs
     * default is not asked
     *
     * @type {WerConsent}
     */
    consent?: WerConsent;
    /**
     * Marks a report as noncritical, so that it is sent silently
     * It will not ask for consent, so you must provide sufficient consent through the consent parameter
     *
     * @type {boolean}
     */
    nonCritical?: boolean;
    /**
     * Only used for testing. It will not actually send it,
     * but it will create the file and print the paramters to the console.
     *
     * @type {boolean}
     */
    sendReport?: boolean;
    /**
     * Where the report file should be placed. default is TEMP
     *
     * @type {string}
     */
    reportDirectory?: string;
    /**
     * whether the report file should be kept or deleted after the report is sent.
     * it is always kept if sendReport is set to false.
     *
     * @type {boolean}
     */
    keepReportFile?: boolean;
}
/**
 * A reporting channel that sends a crash report to Watson.
 *
 * @export
 * @class WatsonReporter
 * @extends {ReportingChannel}
 */
export declare class WatsonReporter extends ReportingChannel {
    /**
     * Creates an instance of WatsonReporter.
     *
     * @param {WerReporterOptions} options
     */
    constructor(options?: WerReporterOptions);
    /**
     * sends the report. Will be called by the reporting framework
     *
     * @param {ErrorInformation} err - information about the error being reported
     * @returns {Promise<string>} - resolves once it has finished reporting
     */
    report(err: ErrorInformation): Promise<string>;
}
